<?php
require_once '../config.php';
session_start();

if(!isset($_SESSION['admin_logged_in'])){
    header("Location: login.php");
    exit;
}

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $key = $_POST['key'];
    $status = $_POST['status'];
    $expiry = $_POST['expiry'];

    $stmt = $conn->prepare("INSERT INTO fxh_licenses (license_key, status, expiry) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $key, $status, $expiry);
    $stmt->execute();
    $stmt->close();

    header("Location: licenses.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<body>
<h2>Create New License</h2>

<form method="post">
    <input type="text" name="key" placeholder="License Key" required><br>
    <select name="status">
        <option value="active">Active</option>
        <option value="inactive">Inactive</option>
    </select><br>
    <input type="date" name="expiry"><br>
    <button type="submit">Create</button>
</form>

</body>
</html>
