<?php
require_once '../config.php';
session_start();

if(!isset($_SESSION['admin_logged_in'])){
    header("Location: login.php");
    exit;
}

// FETCH ALL LICENSES
$result = $conn->query("
    SELECT l.*, u.email 
    FROM fxh_licenses l
    LEFT JOIN fxh_users u ON u.id = l.user_id
    ORDER BY l.id DESC
");
?>
<!DOCTYPE html>
<html>
<head>
<title>FXH License Management</title>
</head>
<body>
<h2>License Management</h2>

<a href="create_license.php">➕ Create New License</a><br><br>

<table border="1" cellpadding="5">
<tr>
    <th>ID</th>
    <th>License Key</th>
    <th>User</th>
    <th>Status</th>
    <th>Expiry</th>
    <th>Actions</th>
</tr>

<?php while($row = $result->fetch_assoc()): ?>
<tr>
    <td><?= $row['id'] ?></td>
    <td><?= $row['license_key'] ?></td>
    <td><?= $row['email'] ? $row['email'] : '— Not assigned —' ?></td>
    <td><?= $row['status'] ?></td>
    <td><?= $row['expiry'] ?></td>
    <td>
        <a href="edit_license.php?id=<?= $row['id'] ?>">Edit</a>
    </td>
</tr>
<?php endwhile; ?>

</table>

</body>
</html>
