<?php
require_once __DIR__.'/../config.php';
require_once __DIR__.'/../middleware/user_auth.php';
?>
<!DOCTYPE html>
<html>
<head>
<title>FX-HUNTER TERMINAL</title>

<link rel="stylesheet" href="/portal/assets/terminal-ui.css">
<script src="https://s3.tradingview.com/tv.js"></script>

</head>
<body>

<div class="fx-term">

    <!-------------- LEFT PANEL -------------->
    <aside class="left-panel">

        <div class="brand">FX-HUNTER</div>

        <div class="watchlist">
            <div class="panel-title">INSTRUMENTS</div>
            <div class="symbols">
                <div>NAS100</div>
                <div>US30</div>
                <div>SPX500</div>
                <div>GER40</div>
                <div>USDJPY</div>
                <div>EURUSD</div>
                <div>XAUUSD</div>
                <div>BTCUSD</div>
                <div>ETHUSD</div>
            </div>
        </div>

        <div class="order-panel">
            <div class="panel-title">ORDER</div>

            <label>Symbol</label>
            <select id="sym">
                <option>XAUUSD</option>
                <option>NAS100</option>
                <option>US30</option>
                <option>SPX500</option>
                <option>GER40</option>
                <option>USDJPY</option>
                <option>EURUSD</option>
            </select>

            <label>Side</label>
            <select id="side">
                <option>BUY</option>
                <option>SELL</option>
            </select>

            <label>Lot</label>
            <div class="lotbox">
                <button onclick="adjLot(-0.01)">−</button>
                <input id="lot" type="number" step="0.01" value="0.01">
                <button onclick="adjLot(0.01)">+</button>
            </div>

            <label>Stop Loss</label>
            <input id="sl">

            <label>Take Profit</label>
            <input id="tp">

            <label>License</label>
            <input id="license">

            <button class="execute-btn" id="send_trade">
                EXECUTE
            </button>

            <div id="trade_status"></div>
        </div>

    </aside>


    <!-------------- CHART PANEL -------------->
    <main class="chart-panel">
        <div id="tv_chart"></div>
    </main>


    <!-------------- BOTTOM DOCK -------------->
    <footer class="bottom-panel">

        <div class="tabs">
            <button class="tab active" data-tab="positions">OPEN POSITIONS</button>
            <button class="tab" data-tab="history">HISTORY</button>
            <button class="tab" data-tab="logs">EXECUTION LOGS</button>
        </div>

        <div class="tab-content active" id="positions">
            <table id="pos-table">
                <thead>
                    <tr>
                        <th>Ticket</th>
                        <th>Symbol</th>
                        <th>Side</th>
                        <th>Lot</th>
                        <th>Entry</th>
                        <th>PnL</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>

        <div class="tab-content" id="history">
            <div class="placeholder">Trade history will appear here</div>
        </div>

        <div class="tab-content" id="logs">
            <div id="exec-feed"></div>
        </div>

    </footer>

</div>


<script>
new TradingView.widget({
    width:"100%",
    height:"100%",
    symbol:"XAUUSD",
    interval:"5",
    timezone:"UTC",
    theme:"dark",
    style:"1",
    container_id:"tv_chart"
});
</script>

<script src="/portal/assets/terminal-ui.js"></script>

</body>
</html>
