<?php
define("FXH_PORTAL", true);
$pageTitle = "Affiliate Plans";

require_once __DIR__.'/../config.php';
require_once __DIR__.'/../config.nowpayments.php';
require_once __DIR__.'/middleware/user_auth.php';
require_once __DIR__.'/includes/header.php';
require_once __DIR__.'/includes/sidebar.php';
?>

<style>
.fxh-affiliate-banner{
    background:linear-gradient(90deg,#ffb347,#ff5f6d);
    border-radius:18px;
    padding:22px 26px;
    text-align:center;
    color:#111;
    font-size:22px;
    font-weight:900;
    margin-bottom:28px;
    box-shadow:0 0 28px rgba(255,120,120,.45);
}

.fxh-affiliate-banner span{
    display:block;
    font-size:15px;
    font-weight:700;
    margin-top:6px;
    opacity:.85;
}

.fxh-plan-grid{
    display:grid;
    grid-template-columns: repeat(auto-fit,minmax(260px,1fr));
    gap:30px;
    margin-top:20px;
}

.fxh-plan-card{
    background:rgba(10,14,22,.92);
    border-radius:18px;
    border:1px solid rgba(0,234,255,.25);
    padding:26px;
    color:#cfeaff;
    text-align:center;
    box-shadow:0 0 22px rgba(0,234,255,.15);
    transition:.25s ease;
}

.fxh-plan-card:hover{
    transform:translateY(-4px);
    box-shadow:0 0 36px rgba(0,234,255,.4);
}

.fxh-plan-card h2{
    color:#00eaff;
    font-size:22px;
}

.fxh-plan-desc{
    opacity:.85;
    margin:10px 0;
}

.fxh-price{
    font-size:26px;
    margin:14px 0;
}

.old{
    text-decoration:line-through;
    opacity:.35;
}

.new{
    color:#00ff9c;
    font-weight:800;
    margin-left:8px;
}

.diamond .new{
    color:#ffd15c;
}

.fxh-buy-btn{
    background:linear-gradient(90deg,#00eaff,#7a35ff);
    border:none;
    border-radius:14px;
    padding:12px 26px;
    color:white;
    font-weight:700;
    cursor:pointer;
    width:100%;
    box-shadow:0 0 18px rgba(0,234,255,.35);
}

.fxh-buy-btn:hover{
    box-shadow:0 0 28px rgba(0,234,255,.65);
}

.diamond{
    border-color:#ffd15c;
}

/* ===============================
   FXH PREMIUM AFFILIATE UI
================================ */

.fxh-section{
    margin:80px auto;
    max-width:1200px;
    padding:0 20px;
}

.fxh-section-title{
    font-size:32px;
    font-weight:800;
    color:#eaf6ff;
    margin-bottom:40px;
    text-align:center;
}

.fxh-glow-grid{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(260px,1fr));
    gap:28px;
}

.fxh-glow-card{
    background:linear-gradient(180deg,rgba(15,20,35,.95),rgba(8,12,22,.95));
    border-radius:22px;
    padding:30px;
    border:1px solid rgba(0,234,255,.18);
    box-shadow:0 0 40px rgba(0,234,255,.08);
    transition:.35s ease;
    position:relative;
    overflow:hidden;
}

.fxh-glow-card:before{
    content:"";
    position:absolute;
    inset:0;
    background:radial-gradient(circle at top,rgba(0,234,255,.18),transparent 60%);
    opacity:.6;
}

.fxh-glow-card:hover{
    transform:translateY(-6px);
    box-shadow:0 0 70px rgba(0,234,255,.28);
}

.fxh-glow-card h3{
    font-size:20px;
    color:#00eaff;
    margin-bottom:12px;
}

.fxh-glow-card p{
    color:#cfeaff;
    opacity:.9;
    line-height:1.6;
}

/* ---- HOW IT WORKS ---- */

.fxh-steps-grid{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(240px,1fr));
    gap:26px;
}

.fxh-step-card{
    background:rgba(12,16,30,.9);
    border-radius:20px;
    padding:26px;
    border:1px solid rgba(122,53,255,.35);
    box-shadow:0 0 35px rgba(122,53,255,.18);
    text-align:center;
}

.fxh-step-num{
    width:54px;
    height:54px;
    margin:0 auto 14px;
    border-radius:50%;
    background:linear-gradient(135deg,#00eaff,#7a35ff);
    color:#fff;
    font-weight:900;
    font-size:20px;
    display:flex;
    align-items:center;
    justify-content:center;
}

.fxh-step-card p{
    color:#eaf6ff;
    font-size:15px;
}

/* ---- EARNINGS ---- */

.fxh-earn-grid{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(260px,1fr));
    gap:26px;
}

.fxh-earn-card{
    background:linear-gradient(180deg,rgba(10,15,28,.95),rgba(5,8,18,.95));
    border-radius:22px;
    padding:32px;
    border:1px solid rgba(0,255,156,.35);
    box-shadow:0 0 45px rgba(0,255,156,.2);
    text-align:center;
}

.fxh-earn-card strong{
    color:#00ff9c;
    font-size:26px;
}

/* ---- FINAL CTA ---- */

.fxh-final-cta{
    text-align:center;
    padding:80px 30px;
    background:linear-gradient(135deg,#00eaff,#7a35ff);
    border-radius:28px;
    box-shadow:0 0 80px rgba(122,53,255,.55);
}

.fxh-final-cta h2{
    color:#fff;
    font-size:34px;
    margin-bottom:14px;
}

.fxh-final-cta p{
    color:#f2f6ff;
    font-size:16px;
    opacity:.9;
    margin-bottom:26px;
}

.fxh-final-cta a{
    background:#0b0f1f;
    color:#fff;
    padding:14px 34px;
    border-radius:16px;
    font-weight:800;
    display:inline-block;
    box-shadow:0 0 25px rgba(0,0,0,.4);
}

/* ===============================
   FXH AFFILIATE HERO HEADER
================================ */

.fxh-hero{
    position:relative;
    margin:40px auto 90px;
    padding:80px 30px;
    border-radius:32px;
    background:
        radial-gradient(circle at top, rgba(0,234,255,.25), transparent 60%),
        linear-gradient(135deg, #0b1022, #050814);
    box-shadow:0 0 120px rgba(0,234,255,.25);
    overflow:hidden;
}

.fxh-hero:before{
    content:"";
    position:absolute;
    inset:-2px;
    border-radius:32px;
    background:linear-gradient(90deg,#00eaff,#7a35ff,#00ff9c);
    filter:blur(22px);
    opacity:.35;
    z-index:0;
    animation:fxhGlowMove 10s linear infinite;
}

@keyframes fxhGlowMove{
    0%{transform:translateX(-30%)}
    100%{transform:translateX(30%)}
}

.fxh-hero-inner{
    position:relative;
    z-index:1;
    max-width:900px;
    margin:auto;
    text-align:center;
}

.fxh-hero-badge{
    display:inline-block;
    padding:8px 18px;
    border-radius:999px;
    background:rgba(0,234,255,.15);
    color:#00eaff;
    font-weight:800;
    font-size:12px;
    letter-spacing:1px;
    margin-bottom:22px;
    box-shadow:0 0 18px rgba(0,234,255,.25);
}

.fxh-hero-title{
    font-size:48px;
    font-weight:900;
    line-height:1.15;
    color:#eaf6ff;
    margin-bottom:18px;
}

.fxh-hero-title span{
    background:linear-gradient(90deg,#00eaff,#7a35ff,#00ff9c);
    -webkit-background-clip:text;
    -webkit-text-fill-color:transparent;
    animation:fxhTextShift 6s linear infinite;
}

@keyframes fxhTextShift{
    0%{filter:hue-rotate(0deg)}
    100%{filter:hue-rotate(360deg)}
}

.fxh-hero-sub{
    font-size:17px;
    color:#cfeaff;
    opacity:.9;
    margin-bottom:34px;
}

.fxh-hero-actions{
    display:flex;
    gap:18px;
    justify-content:center;
    flex-wrap:wrap;
}

.fxh-hero-btn{
    padding:14px 32px;
    border-radius:16px;
    font-weight:800;
    text-decoration:none;
    transition:.25s ease;
}

.fxh-hero-btn.primary{
    background:linear-gradient(90deg,#00eaff,#7a35ff);
    color:#fff;
    box-shadow:0 0 35px rgba(122,53,255,.55);
}

.fxh-hero-btn.primary:hover{
    transform:translateY(-3px);
    box-shadow:0 0 55px rgba(122,53,255,.85);
}

.fxh-hero-btn.ghost{
    border:1px solid rgba(0,234,255,.35);
    color:#00eaff;
    background:rgba(0,234,255,.05);
}

.fxh-hero-btn.ghost:hover{
    background:rgba(0,234,255,.15);
}

/* Responsive */
@media(max-width:768px){
    .fxh-hero-title{font-size:36px}
}
/* ===============================
   FXH PREMIUM PRICING UPGRADE
================================ */

.fxh-plan-card{
    position:relative;
}

.fxh-ribbon{
    position:absolute;
    top:-12px;
    right:-12px;
    background:linear-gradient(90deg,#ffd15c,#ff9f1a);
    color:#111;
    font-size:11px;
    font-weight:900;
    padding:6px 14px;
    border-radius:999px;
    box-shadow:0 0 18px rgba(255,193,7,.6);
}

.fxh-for-badge{
    display:inline-block;
    margin-top:8px;
    font-size:12px;
    padding:4px 10px;
    border-radius:999px;
    background:rgba(0,234,255,.12);
    color:#00eaff;
    font-weight:700;
}

.fxh-plan-features{
    margin:18px 0 70px;
    padding:16px 14px;
    border-radius:14px;
    background:rgba(255,255,255,.03);
    border:1px solid rgba(0,234,255,.15);
    text-align:left;
}

.fxh-plan-features ul{
    list-style:none;
    padding:0;
    margin:0;
}

.fxh-plan-features li{
    font-size:13.5px;
    color:#cfeaff;
    margin:8px 0;
    display:flex;
    gap:8px;
    align-items:flex-start;
    line-height:1.4;
}

.fxh-plan-features li span{
    width:18px;
    text-align:center;
}

.fxh-plan-features .on{ color:#00ff9c; }
.fxh-plan-features .off{ color:rgba(255,255,255,.25); }

.fxh-plan-card{
    display:flex;
    flex-direction:column;
}

.fxh-plan-features{
    flex-grow:1;
}

.fxh-buy-btn{
    margin-top:22px;
    width:100%;
    border-radius:14px;
    background:linear-gradient(90deg,#00eaff,#7a35ff);
    box-shadow:0 0 22px rgba(0,234,255,.35);
    transition:.25s ease;
}

.fxh-buy-btn:hover{
    transform:translateY(-2px);
    box-shadow:0 0 36px rgba(0,234,255,.75);
}

.fxh-plan-card:hover .fxh-buy-btn{
    box-shadow:0 0 45px rgba(0,234,255,.85);
    transform:translateY(-2px);
}
.fxh-ribbon-alt{
    background:linear-gradient(90deg,#00ff9c,#00cfff);
    color:#022;
    box-shadow:0 0 18px rgba(0,255,156,.55);
}

</style>

<div class="fxh-main">

<div class="fxh-hero">
  <div class="fxh-hero-inner">
    <span class="fxh-hero-badge">🤝 AFFILIATE PROGRAM</span>
    <h1 class="fxh-hero-title">
      Build <span>Recurring Income</span><br>
      With FX-HUNTER
    </h1>
    <p class="fxh-hero-sub">
      One-time activation. Permanent pricing advantage. Institutional-grade product.
    </p>
    <div class="fxh-hero-actions">
      <a href="#affiliate-pricing" class="fxh-hero-btn primary">
        Activate Affiliate Access
      </a>
      <a href="#affiliate-pricing" class="fxh-hero-btn primary">
        View Earning Potential
      </a>
    </div>
  </div>
</div>


<div class="fxh-affiliate-banner">
PAY $700 One-Time to Get Increased Profits
<span>After one-time activation, all plans are permanently discounted</span>
</div>

<section class="fxh-section">
  <h2 class="fxh-section-title">Why Become an FX-HUNTER Affiliate?</h2>

  <div class="fxh-glow-grid">
    <div class="fxh-glow-card">
      <h3>Institutional-Grade System</h3>
      <p>FX-HUNTER is a compliance-focused, AI-assisted trading infrastructure designed for serious traders—not retail speculation.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>Recurring Passive Income</h3>
      <p>Earn ongoing commissions from monthly, yearly, and lifetime plans while your referrals continue trading.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>High-Ticket Earnings</h3>
      <p>Lifetime and yearly plans allow affiliates to generate meaningful income per referral.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>Long-Term Retention</h3>
      <p>Low churn due to compliance safety, performance logic, and continuous FX-HUNTER upgrades.</p>
    </div>
  </div>
</section>

<section class="fxh-section">
  <h2 class="fxh-section-title">How the Affiliate Program Works</h2>

  <div class="fxh-steps-grid">
    <div class="fxh-step-card">
      <div class="fxh-step-num">1</div>
      <p>Activate affiliate access with a one-time $700 payment</p>
    </div>

    <div class="fxh-step-card">
      <div class="fxh-step-num">2</div>
      <p>Unlock permanent discounted affiliate pricing</p>
    </div>

    <div class="fxh-step-card">
      <div class="fxh-step-num">3</div>
      <p>Promote FX-HUNTER using your own channels</p>
    </div>

    <div class="fxh-step-card">
      <div class="fxh-step-num">4</div>
      <p>Earn recurring commissions as users subscribe</p>
    </div>
  </div>
</section>

<section class="fxh-section">
  <h2 class="fxh-section-title">Affiliate Earning Potential</h2>

  <div class="fxh-earn-grid">
    <div class="fxh-earn-card">
      <p>10 Monthly Referrals</p>
      <strong>$200–$500 / month</strong>
    </div>

    <div class="fxh-earn-card">
      <p>5 Yearly Plans</p>
      <strong>$350+ / year</strong>
    </div>

    <div class="fxh-earn-card">
      <p>2 Lifetime Plans</p>
      <strong>$1,500+</strong>
    </div>
  </div>
</section>

<section class="fxh-section">
  <div class="fxh-final-cta">
    <h2>Activate Affiliate Access</h2>
    <p>One-time activation. Permanent pricing advantage. Long-term income potential.</p>
    <a href="#affiliate-pricing" class="fxh-hero-btn primary">Activate Now</a>
  </div>
</section>

<section class="fxh-section">
  <h2 class="fxh-section-title">What Affiliates Can Earn (Real Scenarios)</h2>

  <div class="fxh-earn-grid">
    <div class="fxh-earn-card">
      <p>Small Community (Telegram / WhatsApp)</p>
      <strong>$300 – $800 / month</strong>
      <p style="opacity:.7;margin-top:10px">20–30 active traders</p>
    </div>

    <div class="fxh-earn-card">
      <p>Mid-Size YouTube / Discord</p>
      <strong>$1,500 – $4,000 / month</strong>
      <p style="opacity:.7;margin-top:10px">50–150 conversions</p>
    </div>

    <div class="fxh-earn-card">
      <p>Large Trading Community</p>
      <strong>$10,000+ / month</strong>
      <p style="opacity:.7;margin-top:10px">High-ticket + lifetime plans</p>
    </div>
  </div>
</section>

<section class="fxh-section fxh-section-alt">
  <h2 class="fxh-section-title">Why FX-HUNTER Converts Exceptionally Well</h2>

  <div class="fxh-glow-grid">
    <div class="fxh-glow-card">
      <h3>Compliance-First System</h3>
      <p>Prop-firm safe logic increases trust and retention — users don’t churn after violations.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>AI-Driven Decisions</h3>
      <p>AI confidence, risk gating, and trade filtering outperform static EAs.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>High Lifetime Value</h3>
      <p>Users stay longer, upgrade more often, and recommend others organically.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>No Gimmicks</h3>
      <p>Serious traders trust FX-HUNTER because it avoids hype and fake promises.</p>
    </div>
  </div>
</section>
<section class="fxh-section">
  <div class="fxh-final-cta">
    <h2>Serious Affiliates Start Here</h2>
    <p>If you have an audience, FX-HUNTER can monetize it responsibly.</p>
    <a href="#affiliate-pricing" class="fxh-hero-btn primary">Activate Affiliate Access</a>
  </div>
</section>

<section class="fxh-section">
  <h2 class="fxh-section-title">Affiliate-Only Benefits</h2>

  <div class="fxh-glow-grid">
    <div class="fxh-glow-card">
      <h3>Permanent Discounted Pricing</h3>
      <p>Your affiliate pricing never expires once activated.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>Priority Product Updates</h3>
      <p>Affiliates get early access to new FX-HUNTER features.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>High-Ticket Products</h3>
      <p>Yearly and lifetime plans dramatically increase commission potential.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>Long-Term Business Model</h3>
      <p>FX-HUNTER is built as infrastructure — not a short-term EA.</p>
    </div>
  </div>
</section>

<section class="fxh-section fxh-section-alt">
  <h2 class="fxh-section-title">Who Earns the Most as an Affiliate?</h2>

  <div class="fxh-dual-grid">
    <div class="fxh-glow-card">
      <h3>Top Performers</h3>
      <ul style="line-height:1.8">
        <li>✔ Trading educators</li>
        <li>✔ Prop-firm mentors</li>
        <li>✔ Signal providers</li>
        <li>✔ Discord & Telegram admins</li>
      </ul>
    </div>

    <div class="fxh-glow-card">
      <h3>Not Recommended</h3>
      <ul style="line-height:1.8">
        <li>✖ Spam marketers</li>
        <li>✖ Fake performance sellers</li>
        <li>✖ Get-rich-quick promoters</li>
      </ul>
    </div>
  </div>
</section>

<section class="fxh-section">
  <h2 class="fxh-section-title">Built for Long-Term Sustainability</h2>

  <div class="fxh-glow-grid">
    <div class="fxh-glow-card">
      <h3>Server-Verified Licensing</h3>
      <p>Licenses are validated server-side for security and transparency.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>Continuous Development</h3>
      <p>FX-HUNTER evolves continuously — affiliates grow with the platform.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>Institutional Architecture</h3>
      <p>Designed like trading infrastructure, not a disposable EA.</p>
    </div>
  </div>
</section>
<section class="fxh-section fxh-section-alt">
  <h2 class="fxh-section-title">Affiliate Program FAQ</h2>

  <div class="fxh-glow-grid">
    <div class="fxh-glow-card">
      <h3>Is the $700 payment recurring?</h3>
      <p>No. It is a one-time activation for permanent affiliate pricing.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>Do discounts ever expire?</h3>
      <p>No. Once activated, affiliate prices are locked permanently.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>Is FX-HUNTER prop-firm safe?</h3>
      <p>Yes. FX-HUNTER is designed with strict compliance logic.</p>
    </div>

    <div class="fxh-glow-card">
      <h3>Can I promote worldwide?</h3>
      <p>Yes. FX-HUNTER supports global traders.</p>
    </div>
  </div>
</section>
<section class="fxh-section" id="affiliate-activate">
  <div class="fxh-final-cta">
    <h2>Activate Once. Earn for Years.</h2>
    <p>Affiliate access is limited to serious partners only.</p>
    <a href="#affiliate-pricing" class="fxh-hero-btn primary">Activate Affiliate Access Now</a>
  </div>
</section>


<div id="affiliate-pricing" class="fxh-plan-grid">

<!-- ================= BRONZE ================= -->
<div class="fxh-plan-card">
  <h2>BRONZE</h2>
  <p class="fxh-plan-desc">1 Terminal | Monthly</p>
  <span class="fxh-for-badge">📊 Solo Traders</span>

  <div class="fxh-price">
    <span class="old">$20</span>
    <span class="new">$15</span>/mo
  </div>

  <div class="fxh-plan-features">
    <ul>
      <li class="on"><span>🧠</span> AI-assisted trade filtering</li>
      <li class="on"><span>🔒</span> Prop-firm compliance logic</li>
      <li class="on"><span>📉</span> Anti-Martingale protection</li>
      <li class="on"><span>⚖️</span> Risk-based lot sizing</li>
      <li class="on"><span>📊</span> ATR-driven stop-loss</li>
      <li class="off"><span>📈</span> Runner mode expansion</li>
      <li class="off"><span>🧠</span> Advanced AI Gate</li>
      <li class="off"><span>🏛️</span> Institutional analytics</li>
    </ul>
  </div>

  <button class="fxh-buy-btn" data-plan="BRONZE">GET BRONZE ACCESS</button>
</div>

<!-- ================= SILVER ================= -->
<div class="fxh-plan-card">
  <div class="fxh-ribbon">⭐ MOST POPULAR</div>

  <h2>SILVER</h2>
  <p class="fxh-plan-desc">3 Terminals | Monthly</p>
  <span class="fxh-for-badge">📊 Multi-Account Traders</span>

  <div class="fxh-price">
    <span class="old">$30</span>
    <span class="new">$20</span>/mo
  </div>

  <div class="fxh-plan-features">
    <ul>
      <li class="on"><span>🧠</span> Advanced AI Gate decisions</li>
      <li class="on"><span>🔒</span> Multi-prop compliance</li>
      <li class="on"><span>📉</span> Loss-sequence risk lock</li>
      <li class="on"><span>🧮</span> Dynamic risk recalculation</li>
      <li class="on"><span>📊</span> Trade outcome memory</li>
      <li class="on"><span>📈</span> Partial close & runners</li>
      <li class="off"><span>🏛️</span> Institutional analytics</li>
      <li class="off"><span>🔑</span> Lifetime access</li>
    </ul>
  </div>

  <button class="fxh-buy-btn" data-plan="SILVER">GET SILVER ACCESS</button>
</div>

<!-- ================= GOLD ================= -->
<div class="fxh-plan-card">
  <div class="fxh-ribbon fxh-ribbon-alt">💎 BEST VALUE</div>

  <h2>GOLD</h2>
  <p class="fxh-plan-desc">10 Terminals | Yearly</p>
  <span class="fxh-for-badge">📊 Funded / Prop Traders</span>

  <div class="fxh-price">
    <span class="old">$90</span>
    <span class="new">$70</span>/yr
  </div>

  <div class="fxh-plan-features">
    <ul>
      <li class="on"><span>🧠</span> Full AI confidence engine</li>
      <li class="on"><span>🛡️</span> Institutional drawdown guard</li>
      <li class="on"><span>📉</span> Hard Anti-Martingale lock</li>
      <li class="on"><span>📊</span> Performance-aware exits</li>
      <li class="on"><span>⏱️</span> Session-aware execution</li>
      <li class="on"><span>📈</span> Advanced runner mode</li>
      <li class="on"><span>🧾</span> Audit-ready trade logs</li>
      <li class="off"><span>🔑</span> Lifetime access</li>
    </ul>
  </div>

  <button class="fxh-buy-btn" data-plan="GOLD">GET GOLD ACCESS</button>
</div>

<!-- ================= DIAMOND ================= -->
<div class="fxh-plan-card diamond">
  <h2>DIAMOND</h2>
  <p class="fxh-plan-desc">10 Terminals | Lifetime</p>
  <span class="fxh-for-badge">🏛️ Institutions / Long-Term</span>

  <div class="fxh-price">
    <span class="old">$999</span>
    <span class="new">$799</span>
  </div>

  <div class="fxh-plan-features">
    <ul>
      <li class="on"><span>🏛️</span> Institutional trading architecture</li>
      <li class="on"><span>🧠</span> Full AI Gate & heatmap</li>
      <li class="on"><span>🛡️</span> Maximum prop-firm safety</li>
      <li class="on"><span>📉</span> Zero-tolerance Martingale</li>
      <li class="on"><span>📊</span> Advanced analytics suite</li>
      <li class="on"><span>📡</span> Priority infrastructure</li>
      <li class="on"><span>🔑</span> Lifetime license</li>
      <li class="on"><span>🚀</span> All future upgrades</li>
    </ul>
  </div>

  <button class="fxh-buy-btn" data-plan="DIAMOND">GET DIAMOND ACCESS</button>
</div>

</div>

</div>

<script>
document.querySelectorAll(".fxh-buy-btn").forEach(btn=>{
    btn.addEventListener("click", ()=>{
        const plan = btn.dataset.plan;
        window.location.href = "/portal/checkout.php?plan=" + encodeURIComponent(plan);
    });
});
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
