<?php
require_once "../config.php";
require_once "_desktop_guard.php";

header("Content-Type: application/json");

// === ADAPT TO YOUR EXISTING ACCOUNT LOG TABLE ===
$sql = "
    SELECT
        license_key,
        mt5_account,
        equity,
        balance,
        currency
    FROM fxh_account_logs
    WHERE user_id = ?
    ORDER BY updated_at DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$res = $stmt->get_result();

$data = [];
while ($r = $res->fetch_assoc()) {
    $data[] = [
        "license_key" => $r["license_key"],
        "mt5_account" => $r["mt5_account"],
        "equity"      => (float)$r["equity"],
        "balance"     => (float)$r["balance"],
        "currency"    => $r["currency"] ?: "USD"
    ];
}

echo json_encode([
    "success"  => true,
    "accounts" => $data
]);
exit;
