<?php
define("FXH_PORTAL", true);
require_once "../config.php";
require_once "../middleware/user_auth.php";

$user_id = $_SESSION["user_id"];

//
// 1) Load all license keys owned by this user
//
$q = $conn->prepare("SELECT license_key FROM fxh_licenses WHERE user_email = ?");
$q->bind_param("s", $_SESSION["email"]);
$q->execute();
$r = $q->get_result();

$keys = [];
while($x = $r->fetch_assoc()){
    $keys[] = $x['license_key'];
}

if(empty($keys)){
    echo json_encode([]);
    exit;
}

$keyList = "'" . implode("','", $keys) . "'";

//
// 2) Fetch ALL signals attached to those license keys
//
$sql = "
    SELECT
        id,
        symbol,
        action AS direction,
        timeframe AS tf,
        created_at AS ts,
        raw_signal AS raw
    FROM fxh_signal_logs
    WHERE license_key IN ($keyList)
    ORDER BY id DESC
";

$res = $conn->query($sql);

$data = [];
while($row = $res->fetch_assoc()) $data[] = $row;

echo json_encode($data);
exit;
?>
