<?php
require_once __DIR__ . '/../config.php';

header('Content-Type: application/json');

$license = $_GET['license_key'] ?? '';
$mt5     = $_GET['mt5_account'] ?? '';

if(!$license || !$mt5){
    echo json_encode(["status"=>"ERR","msg"=>"missing params"]);
    exit;
}

$sql = "
 SELECT balance,equity,profit,margin,free_margin,margin_level
 FROM fxh_account_logs
 WHERE license_key = ?
 AND mt5_account = ?
 ORDER BY id DESC
 LIMIT 1
";

$st = $conn->prepare($sql);
$st->bind_param("ss",$license,$mt5);
$st->execute();

$res = $st->get_result()->fetch_assoc();

if(!$res){
    echo json_encode(["status"=>"EMPTY"]);
    exit;
}

echo json_encode([
 "status"        => "OK",
 "balance"      => round($res['balance'],2),
 "equity"       => round($res['equity'],2),
 "profit"       => round($res['profit'],2),
 "margin"       => round($res['margin'],2),
 "free_margin" => round($res['free_margin'],2),
 "margin_level"=> round($res['margin_level'],2)
]);
