<?php
require_once __DIR__ . "/../config.php";

if($_SERVER["REQUEST_METHOD"] !== "POST"){
    die("Invalid request");
}

$email  = trim($_POST["email"] ?? "");
$pass   = trim($_POST["password"] ?? "");
$user   = trim($_POST["username"] ?? "");

if(!$email || !$pass){
    die("Missing email/password");
}

$hash = password_hash($pass, PASSWORD_BCRYPT);

$stmt = $conn->prepare("
    INSERT INTO fxh_users (email, password_hash, username)
    VALUES (?, ?, ?)
");
$stmt->bind_param("sss", $email, $hash, $user);

if(!$stmt->execute()){
    die("User already exists");
}

echo "REGISTER_OK";
