<?php
require_once "/var/www/html/portal/config.php";
require_once "/var/www/html/portal/middleware/user_auth.php";

header("Content-Type: application/json");

// SOURCE: fxh_positions_live (REAL MT5 OPEN POSITIONS)
$q = $conn->query("
    SELECT
        ticket,
        symbol,
        type,
        volume,
        price_open,
        sl,
        profit
    FROM fxh_positions_live
    ORDER BY ticket DESC
");

$rows = [];

while ($r = $q->fetch_assoc()) {
    $rows[] = [
        "ticket" => $r["ticket"],
        "symbol" => strtoupper($r["symbol"]),
        "type"   => strtoupper($r["type"]),
        "volume" => (float)$r["volume"],
        "entry"  => (float)$r["price_open"],
        "sl"     => (float)$r["sl"],
        "profit" => (float)$r["profit"]
    ];
}

echo json_encode([
    "status" => "OK",
    "rows"   => $rows
]);
