<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>FX-HUNTER PRO CHART</title>

<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>

<style>
/* =============================
   CORE LAYOUT
============================= */
body{
    margin:0;
    background:#050c10;
    color:#00ffff;
    font-family:Arial,Helvetica,sans-serif;
}

#topbar{
    display:flex;
    align-items:center;
    height:60px;
    padding:10px 20px;
    background:black;
    box-shadow:0 2px 6px #000;
}

#logo{
    height:38px;
    margin-right:15px;
}

/* CURRENT SYMBOL DISPLAY */
#currentSymbolLabel{
    font-weight:bold;
    color:#0ff;
    cursor:pointer;
    padding:8px 14px;
    border:1px solid cyan;
    border-radius:4px;
}

/* WATERMARK */
#watermark{
    position:absolute;
    left:18px;
    bottom:-120px;
    width:160px;
    opacity:0.25;
    pointer-events:none;
    z-index:1;
    filter:drop-shadow(0 0 8px cyan);
}

/* CHART */
#chart{
    height:calc(100vh - 60px);
}

/* =============================
    MODAL UI
============================= */
.modal-overlay{
    position:fixed;
    inset:0;
    background:rgba(0,0,0,.75);
    backdrop-filter:blur(2px);
    display:none;
    align-items:center;
    justify-content:center;
    z-index:999;
}

.modal-box{
    width:620px;
    background:#0b0f18;
    border-radius:12px;
    box-shadow:0 0 25px #00fff55c;
    overflow:hidden;
}

.modal-header input{
    width:100%;
    background:#111827;
    border:0;
    color:#0ff;
    padding:14px;
    font-size:16px;
    outline:none;
}

.modal-tabs{
    display:flex;
    background:#070b12;
}

.modal-tabs .tab{
    flex:1;
    border:0;
    background:none;
    color:#777;
    padding:12px;
    cursor:pointer;
}

.modal-tabs .tab.active{
    color:#0ff;
    background:#111827;
}

.symbol-list{
    max-height:420px;
    overflow-y:auto;
}

.symbol-row{
    display:flex;
    justify-content:space-between;
    padding:11px 15px;
    border-bottom:1px solid #182032;
    cursor:pointer;
}

.symbol-row:hover{
    background:#151e30;
}

.symbol-name{
    color:#0ff;
    font-size:15px;
    font-weight:600;
}

.symbol-desc{
    color:#777;
    font-size:12px;
}

.symbol-broker{
    color:#00ffaa;
}
</style>
</head>

<body>

<!-- =============================
    TOP BAR
============================= -->
<div id="topbar">
    <img id="logo" src="/assets/fx-hunter-logo.png">

    <!-- Symbol Button -->
    <div id="currentSymbolLabel" onclick="openSymbolSearch()">
        XAUUSD (Demo Broker)
    </div>
</div>

<div id="chart"></div>

<img id="watermark" src="/assets/fx-hunter-logo.png">

<!-- =============================
    SYMBOL PICKER MODAL
============================= -->

<div id="symbolModal" class="modal-overlay">
    <div class="modal-box">

        <div class="modal-header">
            <input type="text" id="symbolSearch" placeholder="Search symbol or broker...">
        </div>

        <div class="modal-tabs">
            <button class="tab active" data-asset="All">All</button>
            <button class="tab" data-asset="Forex">Forex</button>
            <button class="tab" data-asset="Crypto">Crypto</button>
            <button class="tab" data-asset="Indices">Indices</button>
            <button class="tab" data-asset="Stocks">Stocks</button>
        </div>

        <div id="symbolList" class="symbol-list"></div>

    </div>
</div>


<script>
/* =============================
   FORMATTER
============================= */
function formatPrice(v){
    return Number(v).toFixed(2);
}


/* =============================
   DEMO CANDLE GENERATOR
============================= */
let candles   = [];
let price     = 2000;
let time      = Date.now();

function loadDemoCandles(symbol,digits){

    candles=[];
    price = 150 + Math.random()*30000;
    time  = Date.now() - (120 * 60000);

    for(let i=0;i<120;i++){

        let o = price;
        let c = o+(Math.random()-.5)*price*0.002;
        let h = Math.max(o,c)+price*0.001;
        let l = Math.min(o,c)-price*0.001;

        candles.push({
            x : new Date(time),
            y : [
                Number(o).toFixed(digits),
                Number(h).toFixed(digits),
                Number(l).toFixed(digits),
                Number(c).toFixed(digits),
            ]
        });

        price=c;
        time+=60000;
    }

    chart.updateSeries([{ data:candles }]);
}


/* =============================
   CHART
============================= */
let chart = new ApexCharts(document.querySelector("#chart"),{

    chart:{
        type:"candlestick",
        height:"100%",
        background:"#050c10",
        animations:{enabled:false},
        toolbar:{
            show:true,
            tools:{
                pan:true,
                zoom:true,
                zoomin:true,
                zoomout:true,
                reset:true,
                download:false,
                selection:true
            }
        }
    },

    series:[{
        name:"FX-HUNTER",
        data:[]
    }],

    plotOptions:{
        candlestick:{
            colors:{
                upward:"#16ff72",
                downward:"#ff3b3b"
            },
            wick:{useFillColor:true}
        }
    },

    grid:{
        borderColor:"#08343e",
        strokeDashArray:2
    },

    xaxis:{
        type:"datetime",
        labels:{
            style:{colors:"#0ff"}
        }
    },

    yaxis:{
        opposite:true,
        labels:{
            formatter:(v)=>formatPrice(v),
            style:{colors:"#0ff"}
        }
    },

    tooltip:{
        theme:"dark",
        x:{ format:"dd MMM HH:mm" },
        y:{ formatter:(v)=>formatPrice(v) }
    }

});

chart.render();
loadDemoCandles("XAUUSD",2);


/* =============================
   MODAL CONTROLS
============================= */
let activeAsset = "All";

function openSymbolSearch(){
    document.getElementById("symbolModal").style.display="flex";
    loadSymbols();
}

document.getElementById("symbolModal").onclick=(e)=>{
    if(e.target.id==="symbolModal"){
        e.target.style.display="none";
    }
};

document.getElementById("symbolSearch").oninput=()=>{
    loadSymbols();
};

document.querySelectorAll(".tab").forEach(tab=>{
    tab.onclick=()=>{
        document.querySelectorAll(".tab").forEach(t=>t.classList.remove("active"));
        tab.classList.add("active");
        activeAsset=tab.dataset.asset;
        loadSymbols();
    };
});


/* =============================
   API SEARCH
============================= */
function loadSymbols(){

    let q = document.getElementById("symbolSearch").value.trim();

    fetch(`/webhook/api/search_symbols.php?q=${encodeURIComponent(q)}&asset=${activeAsset}`)
        .then(r=>r.json())
        .then(d=>renderSymbols(d.results));
}

function renderSymbols(rows){

    let wrap = document.getElementById("symbolList");
    wrap.innerHTML="";

    rows.forEach(r=>{

        let row = document.createElement("div");
        row.className="symbol-row";

        row.innerHTML=`
            <div>
                <div class="symbol-name">${r.symbol}</div>
                <div class="symbol-desc">${r.description||''}</div>
            </div>

            <div class="symbol-broker">${r.broker}</div>
        `;

        row.onclick=()=>{
            selectSymbol(
                r.symbol,
                r.broker_symbol,
                r.broker,
                r.digits
            );
            document.getElementById("symbolModal").style.display="none";
        };

        wrap.appendChild(row);

    });

}


/* =============================
   SYMBOL SELECT HOOK
============================= */
function selectSymbol(symbol,brokerSymbol,broker,digits){

    document.getElementById("currentSymbolLabel")
        .innerText = `${symbol} (${broker})`;

    loadDemoCandles(brokerSymbol,digits);

}
</script>

</body>
</html>
