<?php

/* ------------------------------------------
   FXH LICENSE DECRYPT (Portal Version)
------------------------------------------- */

function fxh_decrypt_license_key($key) {
    $key = trim((string)$key);

    // If key is empty or does NOT start with def5020 → already readable
    if ($key === '' || strpos($key, 'def5020') !== 0) {
        return $key;
    }

    // TRY 1 — WordPress LMFWC decrypt function (if available)
    if (function_exists('lmfwc_decrypt')) {
        try {
            $tmp = lmfwc_decrypt($key);
            if (!empty($tmp) && strpos($tmp, 'def5020') !== 0) {
                return trim($tmp);
            }
        } catch (Throwable $e) {}
    }

    // TRY 2 — fallback: return original hashed key (cannot decrypt)
    return $key;
}
