<?php 
require_once "config.php";
require_once "auth_check.php";
$page = "logs";
?>
<?php include "header.php"; ?>

<div class="container mt-4">
    <h3 class="mb-3">📝 EA Logs</h3>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Type</th>
                <th>Message</th>
                <th>Symbol</th>
                <th>Time</th>
            </tr>
        </thead>
        <tbody id="logTable"></tbody>
    </table>
</div>

<script>
function loadLogs(){
    fetch("api/get_logs.php")
    .then(r => r.json())
    .then(data => {
        let html = "";
        data.forEach(l => {
            html += `
            <tr>
                <td>${l.id}</td>
                <td>${l.type}</td>
                <td>${l.msg}</td>
                <td>${l.symbol}</td>
                <td>${l.ts}</td>
            </tr>`;
        });
        document.getElementById("logTable").innerHTML = html;
    });
}
loadLogs();
</script>

<?php include "footer.php"; ?>
