<?php
define("FXH_PORTAL", true);
$pageTitle = "Signals";

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../middleware/user_auth.php';
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/sidebar.php';
?>

<div class="fxh-main">
    <h1>Signals</h1>

    <table class="table table-dark table-striped mt-4">
        <thead>
            <tr>
                <th>ID</th>
                <th>License</th>
                <th>Symbol</th>
                <th>Direction</th>
                <th>Timeframe</th>
                <th>Time</th>
                <th>Raw</th>
            </tr>
        </thead>
        <tbody id="signalTable"></tbody>
    </table>
</div>

<script>
function loadSignals(){
    fetch("api/get_signals.php")
    .then(r => r.json())
    .then(data => {
        let html = "";
        data.forEach(s => {
            html += `
            <tr>
                <td>${s.id}</td>
                <td>${s.license_key}</td>
                <td>${s.symbol}</td>
                <td>${s.direction}</td>
                <td>${s.tf}</td>
                <td>${s.ts}</td>
                <td><pre>${s.raw_signal}</pre></td>
            </tr>`;
        });
        document.getElementById("signalTable").innerHTML = html;
    });
}
loadSignals();
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
