<?php
require_once 'wp-password.php';
require_once 'password_verify_fxh.php';
require_once 'config.php';

$conn = fxh_db();

// PUT YOUR EMAIL HERE (the one you're testing)
$email = "digimartltd@gmail.com";

// PUT THE PASSWORD YOU ARE TESTING HERE
$pass = FXH_DB_PASS;

echo "<h2>FXH PASSWORD DEBUG</h2>";

$stmt = $conn->prepare("SELECT ID, user_login, user_pass FROM fxhai_users WHERE user_email = ? LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$res = $stmt->get_result();
$stmt->close();

if ($res->num_rows === 0) {
    die("User not found.");
}

$user = $res->fetch_assoc();
$hash = $user['user_pass'];

echo "<pre>";
echo "Stored Hash:  " . $hash . "\n";
echo "Input Pass:   " . $pass . "\n\n";

// TEST 1 — fxh_check_password()
echo "fxh_check_password(): ";
var_dump(fxh_check_password($pass, $hash));
echo "\n";

// TEST 2 — raw password_verify for bcrypt
if (substr($hash, 0, 3) === '$wp') {
    $bcrypt = substr($hash, 3);
    echo "password_verify(bcrypt): ";
    var_dump(password_verify($pass, $bcrypt));
    echo "\n";
}

// TEST 3 — WP Portable Hash
$wp_hasher = new WP_PasswordHash(8, true);
echo "WP_PasswordHash->CheckPassword(): ";
var_dump($wp_hasher->CheckPassword($pass, $hash));
echo "\n";

// TEST 4 — raw password_verify() without modifications
echo "password_verify(raw): ";
var_dump(password_verify($pass, $hash));
echo "\n";

echo "</pre>";
?>
