<?php 
require_once "config.php";
require_once "auth_check.php";
$page = "trades";
?>
<?php include "header.php"; ?>

<div class="container mt-4">
    <h3 class="mb-3">📈 Trade History</h3>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Ticket</th>
                <th>Symbol</th>
                <th>Type</th>
                <th>Volume</th>
                <th>Open Price</th>
                <th>Close Price</th>
                <th>Profit</th>
                <th>Opened</th>
                <th>Closed</th>
            </tr>
        </thead>
        <tbody id="tradeTable"></tbody>
    </table>
</div>

<script>
function loadTrades() {
    fetch("api/get_trades.php")
    .then(r => r.json())
    .then(data => {
        let html = "";
        data.forEach(t => {
            html += `
            <tr>
                <td>${t.ticket}</td>
                <td>${t.symbol}</td>
                <td>${t.type}</td>
                <td>${t.volume}</td>
                <td>${t.open_price}</td>
                <td>${t.close_price}</td>
                <td>${t.profit}</td>
                <td>${t.open_time}</td>
                <td>${t.close_time}</td>
            </tr>`;
        });
        document.getElementById("tradeTable").innerHTML = html;
    });
}
loadTrades();
</script>

<?php include "footer.php"; ?>
