<?php
define("FXH_PORTAL", true);
$pageTitle = "Account Settings";

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../middleware/user_auth.php';

$user_id    = $_SESSION['user_id'];

// Load user from `fxhai_users`
$stmt = $conn->prepare("
    SELECT user_nicename, display_name, user_email 
    FROM fxhai_users 
    WHERE ID = ?
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

require_once __DIR__ . "/includes/header.php";
require_once __DIR__ . "/includes/sidebar.php";
?>

<style>
/* ============================
   PREMIUM NEON ACCOUNT UI
============================ */

.fxh-main { padding: 40px; color: #fff; }

.acc-title {
    font-size: 36px;
    font-weight: 900;
    background: linear-gradient(90deg,#00eaff,#7a35ff);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.acc-subtitle {
    color:#9aa3c2;
    font-size: 15px;
    margin-bottom: 30px;
}

.acc-card {
    background: rgba(13,18,27,0.92);
    padding: 32px;
    border-radius: 22px;
    border: 1px solid rgba(0,255,255,0.15);
    box-shadow: 0 0 18px rgba(0,255,255,0.15);
    max-width: 650px;
    margin-bottom: 40px;
}

.acc-label { color:#9aa3c2; font-size: 14px; margin-bottom:6px; }
.acc-input { 
    width:100%; padding:14px;
    border-radius:12px; 
    border:1px solid rgba(255,255,255,0.08);
    background:rgba(255,255,255,0.05);
    color:white; font-size:15px;
    margin-bottom:18px;
}
.acc-input:focus {
    border-color:#00eaff;
    box-shadow:0 0 10px #00eaffaa;
    outline:none;
}

.neon-btn-save {
    width:100%; padding:16px;
    border-radius:14px;
    font-size:16px; font-weight:700;
    background:linear-gradient(45deg,#7a35ff,#00eaff);
    border:none; color:white;
    box-shadow:0 0 15px #00eaff66;
    cursor:pointer;
}
.neon-btn-save:hover { 
    transform:translateY(-3px);
    box-shadow:0 0 28px #00eaffaa;
    transition:0.25s;
}
</style>


<div class="fxh-main">

    <div class="acc-title">Account Settings</div>
    <div class="acc-subtitle">Update your profile and secure your account.</div>


    <!-- ===========================
         PROFILE INFO
    ============================ -->
    <div class="acc-card">
        <form action="account_update.php" method="POST">

            <div class="acc-label">Full Name</div>
            <input type="text" name="first_name" class="acc-input"
                   value="<?= htmlspecialchars($user['user_nicename']) ?>">

            <div class="acc-label">Display Name</div>
            <input type="text" name="last_name" class="acc-input"
                   value="<?= htmlspecialchars($user['display_name']) ?>">

            <div class="acc-label">Email</div>
            <input type="email" name="email" class="acc-input"
                   value="<?= htmlspecialchars($user['user_email']) ?>">

            <button type="submit" class="neon-btn-save">Save Changes</button>
        </form>
    </div>


    <!-- ===========================
         PASSWORD CHANGE
    ============================ -->
    <div class="acc-card">
        <form action="password_update.php" method="POST">

            <div class="acc-label">Current Password</div>
            <input type="password" name="old_password" class="acc-input" required>

            <div class="acc-label">New Password</div>
            <input type="password" name="new_password" class="acc-input" required>

            <div class="acc-label">Repeat New Password</div>
            <input type="password" name="repeat_password" class="acc-input" required>

            <button type="submit" class="neon-btn-save">Update Password</button>
        </form>
    </div>

</div>

<?php require_once __DIR__ . "/includes/footer.php"; ?>
