<?php
require_once __DIR__ . '/../config.php';

$userEmail = $_SESSION['email'] ?? "";

$out=[];

$q = $conn->prepare("
SELECT l.id, l.license_key, l.mt5_account, a.last_seen,
       al.balance,
       al.equity,
       al.profit
FROM fxh_licenses l

LEFT JOIN fxh_license_activations a
    ON a.license_key = l.license_key

LEFT JOIN fxh_account_logs al
    ON al.license_key = l.license_key
   AND al.mt5_account = l.mt5_account

WHERE l.user_email = ?
ORDER BY al.id DESC
");

$q->bind_param("s",$userEmail);
$q->execute();
$res = $q->get_result();

while($r=$res->fetch_assoc()){

    $active = $r['last_seen'] && (strtotime($r['last_seen']) > time()-75);

    $out[]=[
        "license_id"=>$r['id'],
        "active"=>$active,
        "profit"=>round((float)$r['profit'],2),
        "pnl"=>(($r['profit']>=0?"+":"").number_format($r['profit'],2))
    ];
}

echo json_encode($out);
