<?php
require_once __DIR__ . "/../config.php";
?>

<!DOCTYPE html>
<html>
<head>
    <title>FX-HUNTER | Register</title>

    <!-- GOOGLE FONT -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif;
            background: #0B0E15;
            color: #fff;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .login-container {
            width: 100%;
            max-width: 420px;
            background: #111522;
            padding: 40px 35px;
            border-radius: 18px;
            box-shadow: 0 0 25px rgba(0, 230, 255, 0.15);
            text-align: center;
        }

        .login-logo img {
            width: 220px;
            filter: drop-shadow(0 0 12px rgba(0,230,255,0.35));
            margin-bottom: 25px;
            margin-top: -10px;
        }

        .login-title {
            font-size: 22px;
            color: #0fe4ff;
            font-weight: 600;
            margin-bottom: 25px;
        }

        .fxh-input {
            width: 100%;
            margin-bottom: 18px;
            padding: 14px;
            border-radius: 10px;
            border: 1px solid #2A3346;
            background: #0F141E;
            color: #e8f6ff;
            font-size: 15px;
        }

        .fxh-input:focus {
            outline: none !important;
            border-color: #00eaff;
            box-shadow: 0 0 8px rgba(0,234,255,0.45);
        }

        .fxh-btn {
            width: 100%;
            background: #00eaff;
            color: #000;
            padding: 12px;
            font-size: 16px;
            border-radius: 10px;
            border: none;
            cursor: pointer;
            font-weight: 600;
            letter-spacing: 0.5px;
            box-shadow: 0 0 12px rgba(0,234,255,0.35);
            transition: .25s;
        }

        .fxh-btn:hover {
            background: #09f2ff;
            box-shadow: 0 0 20px rgba(0,234,255,0.55);
        }

        .fxh-footer {
            margin-top: 18px;
            font-size: 13px;
            opacity: 0.5;
        }

        .fxh-link {
            margin-top:12px;
            font-size:13px;
        }
        .fxh-link a{
            color:#00eaff;
            text-decoration:none;
        }
        .fxh-link a:hover{
            text-decoration:underline;
        }
    </style>
</head>

<body>

<div class="login-container">

    <!-- LOGO -->
    <div class="login-logo">
        <img src="/portal/user/assets/fx-hunter-logo.png" alt="FX-HUNTER Logo">
    </div>

    <div class="login-title">Create Your FX-HUNTER Account</div>

    <?php
    $msg = fxh_get_flash();
    if($msg):
    ?>
    <div style="
        background: <?= $msg['type']=='success' ? '#093' : '#300'; ?>;
        color:#fff;
        padding:10px 15px;
        border-radius:10px;
        margin-bottom:15px;
        box-shadow:0 0 10px rgba(0,255,255,.3);
        font-size:14px;
        text-align:center;
    ">
        <?= htmlspecialchars($msg['msg']) ?>
    </div>
    <?php endif; ?>

    <!-- REGISTER FORM -->
    <form action="register_process.php" method="POST">

        <input type="text" name="first_name" class="fxh-input" placeholder="First Name" required>

        <input type="text" name="last_name" class="fxh-input" placeholder="Last Name" required>

        <input type="email" name="email" class="fxh-input" placeholder="Email Address" required>

        <input type="password" name="password" class="fxh-input" placeholder="Password" required>

        <input type="password" name="confirm_password" class="fxh-input" placeholder="Confirm Password" required>

        <button class="fxh-btn">Create Account</button>
    </form>

    <div class="fxh-link">
        Already have an account?
        <a href="/portal/user/login.php">Login here</a>
    </div>

    <div class="fxh-footer">
        © <?= date("Y") ?> FX-HUNTER — All Rights Reserved.
    </div>

</div>
</body>
</html>
