<?php
define('FXH_PORTAL', true);
require_once "../middleware/user_auth.php";
require_once "../config.php";

header('Content-Type: text/plain; charset=utf-8');

$ticket = isset($_POST['ticket']) ? trim($_POST['ticket']) : '';

if ($ticket === '') {
    http_response_code(400);
    echo "Invalid ticket";
    exit;
}

$user_id = (int)($_SESSION['user_id'] ?? 0);

// Simple file-based queue for now
$logFile = __DIR__ . "/../logs/trade_commands.log";
if (!is_dir(dirname($logFile))) {
    mkdir(dirname($logFile), 0755, true);
}

$line = sprintf(
    "[%s] CLOSE | user=%d | ticket=%s\n",
    gmdate('Y-m-d H:i:s'),
    $user_id,
    $ticket
);
file_put_contents($logFile, $line, FILE_APPEND);

echo "Close command queued for ticket {$ticket}";
