<?php require_once "/var/www/html/config.database.php"; ?>
<?php

/* ==========================================================
   FXH CONFIG
   Central configuration for ALL webhook API endpoints
   ========================================================== */

require_once "/var/www/html/config.database.php";        // your real DB host
// removed central config               // your DB user
// removed central config        // <-- replace
// removed central config               // your main DB

define('FXH_DEBUG', false);     // true = verbose logs
define('FXH_ADMIN_KEY', 'fxh-super-key-2025'); // for admin-only API calls

/* Log folder */
define('FXH_LOG_DIR', __DIR__ . '/logs');
if(!is_dir(FXH_LOG_DIR)) mkdir(FXH_LOG_DIR, 0755, true);

/* Create DB connection */
function fxh_db() {
    static $db = null;
    if($db === null) {
        mysqli_report(MYSQLI_REPORT_OFF);
        $db = new mysqli(FXH_DB_HOST, FXH_DB_USER, FXH_DB_PASS, FXH_DB_NAME);
        if ($db->connect_errno) {
            fxh_log("DB ERROR: " . $db->connect_error);
            return null;
        }
        $db->set_charset("utf8mb4");
    }
    return $db;
}

/* Logging */
function fxh_log($msg, $file = 'main.log') {
    $line = "[" . gmdate('Y-m-d H:i:s') . "] " . $msg . "\n";
    file_put_contents(FXH_LOG_DIR . '/' . $file, $line, FILE_APPEND);
}

?>
