<?php
// FX-HUNTER EA POLL ENDPOINT - SAFE VERSION
// This file NEVER throws HTTP 500

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");

// ------------------------------------------------
// Load Config (CHANGE PATH IF NEEDED)
// ------------------------------------------------
require_once __DIR__ . "/../portal/config.php";

// ------------------------------------------------
// Input validation
//-------------------------------------------------
$license = $_GET['license'] ?? '';
$mt5     = $_GET['mt5'] ?? '';

if($license == '' || $mt5 == '') {
    echo json_encode(["status"=>"EMPTY"]);
    exit;
}

// ------------------------------------------------
// DB Query (safe + limited)
//-------------------------------------------------
$sql = "
SELECT id,
       trade_uuid,
       license_key,
       symbol,
       action,
       volume,
       sl,
       tp
FROM fxh_trade_queue
WHERE license_key=?
  AND status='PENDING'
ORDER BY id ASC
LIMIT 1
";

$stmt = $conn->prepare($sql);
if(!$stmt) {
    echo json_encode(["status"=>"DB_PREP_FAIL"]);
    exit;
}

$stmt->bind_param("s", $license);
$stmt->execute();
$res = $stmt->get_result();

$row = $res->fetch_assoc();

if(!$row) {
    echo json_encode(["status"=>"NO_TRADES"]);
    exit;
}

// ------------------------------------------------
// VALID JSON RESPONSE
//-------------------------------------------------
echo json_encode($row);
exit;
