<?php
/* ==================================================
   FX-HUNTER — STORE DRAWNDOWN LOG (PHASE-15 FINAL)
   ================================================== */

ini_set('display_errors',1);
error_reporting(E_ALL);

require_once "/var/www/html/config.database.php";
require_once __DIR__ . "/config_webhook.php";

header("Content-Type: text/plain");

$db = fxh_db();
if(!$db)
{
    http_response_code(500);
    echo "DB_ERROR";
    exit;
}

// --------------------------------------------------
// POST ONLY
// --------------------------------------------------
if($_SERVER['REQUEST_METHOD'] !== 'POST')
{
    http_response_code(405);
    echo "INVALID_METHOD";
    exit;
}

// --------------------------------------------------
// INPUT
// --------------------------------------------------
$license = $_POST['license_key'] ?? '';
$account = $_POST['mt5_account'] ?? 0;
$dd      = $_POST['dd'] ?? 0;

// --------------------------------------------------
// VALIDATION
// --------------------------------------------------
if($license === '' || $account == 0)
{
    http_response_code(400);
    echo "MISSING_FIELDS";
    exit;
}

$dd = floatval($dd);

// --------------------------------------------------
// INSERT
// --------------------------------------------------
$stmt = $db->prepare("
INSERT INTO fxh_dd_logs
(license_key, mt5_account, dd_percent)
VALUES (?,?,?)
");

$stmt->bind_param(
    "sid",
    $license,
    $account,
    $dd
);

if(!$stmt->execute())
{
    http_response_code(500);
    echo "EXECUTE_ERROR";
    exit;
}

echo "OK";
