<?php
/* ==================================================
   FX-HUNTER — STORE EVENT LOG (PRODUCTION FINAL)
   ================================================== */

ini_set('display_errors',1);
error_reporting(E_ALL);

require_once "/var/www/html/config.database.php";
require_once __DIR__ . "/config_webhook.php";

header("Content-Type: text/plain");

// --------------------------------------------------
// POST ONLY
// --------------------------------------------------
if($_SERVER['REQUEST_METHOD'] !== 'POST')
{
    http_response_code(405);
    echo "INVALID_METHOD";
    exit;
}

// --------------------------------------------------
// READ INPUT (RAW + POST SAFE)
// --------------------------------------------------
$raw = file_get_contents("php://input");
$data = [];
parse_str($raw, $data);

if(empty($data) && !empty($_POST))
    $data = $_POST;

// --------------------------------------------------
// REQUIRED FIELDS
// --------------------------------------------------
$required = [
    'license_key',
    'mt5_account',
    'symbol',
    'event_type',
    'price',
    'volume',
    'message'
];

foreach($required as $f)
{
    if(!isset($data[$f]) || $data[$f]==='')
    {
        http_response_code(400);
        echo "MISSING_FIELD:$f";
        exit;
    }
}

// --------------------------------------------------
// INSERT EVENT
// --------------------------------------------------
$sql = "
INSERT INTO fxh_event_logs
(license_key, mt5_account, symbol, event_type,
 price, volume, message, created_at)
VALUES (?,?,?,?,?,?,?,NOW())
";

$stmt = $db->prepare($sql);
if(!$stmt)
{
    http_response_code(500);
    echo "PREPARE_ERROR";
    exit;
}

$stmt->bind_param(
    "sissdds",
    $data['license_key'],
    $data['mt5_account'],
    $data['symbol'],
    $data['event_type'],
    $data['price'],
    $data['volume'],
    $data['message']
);

if(!$stmt->execute())
{
    http_response_code(500);
    echo "EXECUTE_ERROR";
    exit;
}

// --------------------------------------------------
// SUCCESS
// --------------------------------------------------
echo "OK";
