<?php require_once "/var/www/html/config.database.php"; ?>
<?php
require_once __DIR__ . "/config_webhook.php";

$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

if (!$data) {
    http_response_code(400);
    echo json_encode(["status" => "INVALID_JSON"]);
    exit;
}

$license = trim($data['license_key'] ?? "");
$ticket  = intval($data['ticket'] ?? 0);
$volume  = floatval($data['volume'] ?? 0);

if ($license == "" || $ticket == 0 || $volume <= 0) {
    http_response_code(400);
    echo json_encode(["status" => "MISSING_FIELDS"]);
    exit;
}

fxh_log("PARTIAL REQUEST → License=$license Ticket=$ticket Vol=$volume", "trade.log");

echo json_encode([
    "status" => "OK",
    "action" => "partial",
    "ticket" => $ticket,
    "volume" => $volume
]);
?>
